/*
 * Decompiled with CFR 0.152.
 */
package jade.domain.KBManagement;

import jade.core.AID;
import jade.domain.FIPAAgentManagement.DFAgentDescription;
import jade.domain.FIPAAgentManagement.NotUnderstoodException;
import jade.domain.KBManagement.KB;
import jade.domain.KBManagement.KBIterator;
import jade.proto.SubscriptionResponder;
import jade.util.Logger;
import jade.util.leap.ArrayList;
import jade.util.leap.List;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public abstract class DBKB
extends KB {
    protected String driver = "sun.jdbc.odbc.JdbcOdbcDriver";
    protected Connection conn = null;
    private String url;
    private String username;
    private String password;
    protected boolean cleanTables;

    public DBKB(String url, int maxResultLimit, boolean cleanTables) throws SQLException {
        this(null, url, maxResultLimit, cleanTables);
    }

    public DBKB(String drv, String url, int maxResultLimit, boolean cleanTables) throws SQLException {
        this(drv, url, null, null, maxResultLimit, cleanTables);
    }

    public DBKB(String drv, String url, String username, String password, int maxResultLimit, boolean cleanTables) throws SQLException {
        super(maxResultLimit);
        this.cleanTables = cleanTables;
        this.loadDBDriver(drv);
        this.setDBConnection(url, username, password);
        this.setup();
    }

    protected void loadDBDriver(String drv) throws SQLException {
        try {
            if (drv != null && !drv.equals("null")) {
                this.driver = drv;
            }
            Class.forName(this.driver).newInstance();
        }
        catch (Exception e) {
            throw new SQLException("Error loading driver " + this.driver + ". " + e);
        }
    }

    protected void setDBConnection(String url, String username, String password) throws SQLException {
        this.conn = username != null ? DriverManager.getConnection(url, username, password) : DriverManager.getConnection(url);
        this.url = url;
        this.username = username;
        this.password = password;
    }

    protected void refreshDBConnection() throws SQLException {
        try {
            this.conn.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        this.setDBConnection(this.url, this.username, this.password);
    }

    protected abstract void setup() throws SQLException;

    protected Object insert(Object name, Object fact) {
        try {
            return this.insertSingle(name, fact);
        }
        catch (SQLException sqle) {
            try {
                this.logger.log(Logger.WARNING, "Refreshing DB connection...");
                this.refreshDBConnection();
                this.logger.log(Logger.INFO, "DB connection correctly refreshed");
                return this.insertSingle(name, fact);
            }
            catch (Exception e) {
                this.logger.log(Logger.SEVERE, "DB error inserting DFD for agent " + ((DFAgentDescription)fact).getName().getName(), sqle);
                return null;
            }
        }
    }

    protected abstract Object insertSingle(Object var1, Object var2) throws SQLException;

    protected Object remove(Object name) {
        try {
            return this.removeSingle(name);
        }
        catch (SQLException sqle) {
            try {
                this.logger.log(Logger.WARNING, "Refreshing DB connection...");
                this.refreshDBConnection();
                this.logger.log(Logger.INFO, "DB connection correctly refreshed");
                return this.removeSingle(name);
            }
            catch (Exception e) {
                this.logger.log(Logger.SEVERE, "DB error removing DFD for agent " + ((AID)name).getName(), sqle);
                return null;
            }
        }
    }

    protected abstract Object removeSingle(Object var1) throws SQLException;

    public List search(Object template, int maxResult) {
        try {
            return this.searchSingle(template, maxResult);
        }
        catch (SQLException sqle) {
            try {
                this.logger.log(Logger.WARNING, "Refreshing DB connection...");
                this.refreshDBConnection();
                this.logger.log(Logger.INFO, "DB connection correctly refreshed");
                return this.searchSingle(template, maxResult);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.logger.log(Logger.SEVERE, "DB error during search operation.", sqle);
                return new ArrayList();
            }
        }
    }

    protected abstract List searchSingle(Object var1, int var2) throws SQLException;

    public KBIterator iterator(Object template) {
        try {
            return this.iteratorSingle(template);
        }
        catch (SQLException sqle) {
            try {
                this.logger.log(Logger.WARNING, "Refreshing DB connection...");
                this.refreshDBConnection();
                this.logger.log(Logger.INFO, "DB connection correctly refreshed");
                return this.iteratorSingle(template);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.logger.log(Logger.SEVERE, "DB error during iterated search operation.", sqle);
                return new EmptyKBIterator();
            }
        }
    }

    protected abstract KBIterator iteratorSingle(Object var1) throws SQLException;

    public void subscribe(Object template, SubscriptionResponder.Subscription s) throws NotUnderstoodException {
        try {
            this.subscribeSingle(template, s);
        }
        catch (SQLException sqle) {
            try {
                this.logger.log(Logger.WARNING, "Refreshing DB connection...");
                this.refreshDBConnection();
                this.logger.log(Logger.INFO, "DB connection correctly refreshed");
                this.subscribeSingle(template, s);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.logger.log(Logger.SEVERE, "DB error during iterated search operation.", sqle);
            }
        }
    }

    protected abstract void subscribeSingle(Object var1, SubscriptionResponder.Subscription var2) throws SQLException, NotUnderstoodException;

    public abstract Enumeration getSubscriptions();

    public void unsubscribe(SubscriptionResponder.Subscription s) {
        try {
            this.unsubscribeSingle(s);
        }
        catch (SQLException sqle) {
            try {
                this.logger.log(Logger.WARNING, "Refreshing DB connection...");
                this.refreshDBConnection();
                this.logger.log(Logger.INFO, "DB connection correctly refreshed");
                this.unsubscribeSingle(s);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.logger.log(Logger.SEVERE, "DB error during iterated search operation.", sqle);
            }
        }
    }

    protected abstract void unsubscribeSingle(SubscriptionResponder.Subscription var1) throws SQLException;

    protected class EmptyKBIterator
    implements KBIterator {
        protected EmptyKBIterator() {
        }

        public boolean hasNext() {
            return false;
        }

        public Object next() {
            throw new NoSuchElementException("");
        }

        public void remove() {
        }

        public void close() {
        }
    }
}

